        PROGRAM NJMREG


c       laatste verandering: 7-1-2019
        
        real x(9000),y(9000),z(9000),v(9000),w(9000)
        real cmlr(4,4),cinv(4,4),cmlrw(5,5),cinvw(5,5)
        character*40 inaam
        character*40 unaam
        character*2 zxcv

        nrij = 9000

c       Supplement van NJSTAT: tot en met versie 30.0 onderdeel
c       van NJSTAT maar apart gemaakt omdat de code te groot werd
c       voor MS Fortran 4.10 (en dus voor een 16-bit executable)


10      write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) '  NJMREG options:'
        write(*,*) ' '
        write(*,*) '      multiple linear regression                (1)'
        write(*,*) ' '
        write(*,*) '      some info and help                        (2)'
        write(*,*) '      exit                                      (3)'
        read(*,'(A)') zxcv
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '

        if (zxcv.eq.'1') then          
          write(*,*) '      **** multiple linear regression ****'
          write(*,*) ' '
          write(*,*) ' '
          goto 1300
        end if
        if ((zxcv.eq.'2').or.(zxcv.eq.'h')) then          
          goto 1995
        end if
        if ((zxcv.eq.'3').or.(zxcv.eq.'e')) then
          goto 2000
        else
          goto 10
        end if


c       multiple linear regression gedeelte

1300    write(*,*) ' '
        write(*,*) '      name of datafile'
        read(*,'(A)') inaam
1302    write(*,*) ' '
        write(*,*) '      number of rows'
        read(*,*) n
1304    format(A,I4)
        if ((n.lt.6).or.(n.gt.nrij)) then
          write(*,*) ' '
          write(*,1304) ' n should be 6,7,...,',nrij
          goto 1302
        end if
1305    write(*,*) ' '
        write(*,*) '      two (2), three (3), or four (4) independent va
     criables'
        read(*,'(A)') zxcv
        if (zxcv.eq.'2') then
          goto 1310
        end if
        if (zxcv.eq.'3') then
          goto 1340
        end if
        if (zxcv.eq.'4') then
          goto 1370
        else
          write(*,*) ' '
          write(*,*) 'input not correct'
          goto 1305
        end if

c       subgedeelte voor twee onafhankelijke variabelen

1310    open(unit=13,file=inaam)
        do 1312,i=1,n,1
          read(unit=13,fmt=*) a,b,c
          x(i) = a
          y(i) = b
          z(i) = c
1312    continue
        close(unit=13)

c       uit Fortran 77 van GJ Borse p 506-7, aangepast voor multipele 
c       lineaire regressie met twee onafhankelijke variabelen:
        sx = 0
        sz = 0
        sxx = 0
        szz = 0
        sxz = 0
        sy = 0
        sxy = 0
        szy = 0
        do 1320,i=1,n,1
          sx = sx+x(i)
          sz = sz+z(i)
          sxx = sxx+x(i)*x(i)
          szz = szz+z(i)*z(i)
          sxz = sxz+x(i)*z(i)
          sy = sy+y(i)
          sxy = sxy+x(i)*y(i)
          szy = szy+z(i)*y(i)
1320    continue
        an = n
        call drie(an,sx,sz,sx,sxx,sxz,sz,sxz,szz,
     csy,sxy,szy,b0,b1,b2)
c       uit essentials of biostatistics
        ygem = 0
        do 1322,i=1,n,1
          ygem = ygem+y(i)/n
1322    continue
        sse = 0
        ssr = 0
        do 1324,i=1,n,1
          ymod = b0+b1*x(i)+b2*z(i)
          ssr = ssr+((ymod-ygem)*(ymod-ygem))
          sse = sse+((y(i)-ymod)*(y(i)-ymod))
1324    continue
        f = (ssr/2)/(sse/(n-3))
        sst = ssr+sse
        r = sqrt(ssr/sst)
c       berekening "adjusted R-kwadraat" (Howell p 497)
        arr = 1-(n-1)*(1-ssr/sst)/(n-3)

c       berekening t voor b1 en b2 (weet niet meer waar dit gevonden)
c       daartoe eerst r berekenen tussen kolom 1-2 en tussen 2-3
c       voor berekening r zie y = ax + b gedeelte
        xgem = 0
        ygem = 0
        zgem = 0
        do 1326,i=1,n,1
          xgem = xgem+x(i)/n
          ygem = ygem+y(i)/n
          zgem = zgem+z(i)/n
1326    continue
        ssx = 0
        ssy = 0
        ssz = 0
        sxy = 0
        syz = 0
        do 1328,i=1,n,1
          ssx = ssx+(x(i)-xgem)*(x(i)-xgem)
          ssy = ssy+(y(i)-ygem)*(y(i)-ygem)
          ssz = ssz+(z(i)-zgem)*(z(i)-zgem)
          sxy = sxy+(x(i)-xgem)*(y(i)-ygem)
          syz = syz+(y(i)-ygem)*(z(i)-zgem)
1328    continue
        r12 = sxy/(sqrt(ssx*ssy))
        r23 = syz/(sqrt(ssy*ssz))
c       nu t berekenen
        t1 = sqrt((r*r-r23*r23)*(n-3)/(1-r*r))
        t2 = sqrt((r*r-r12*r12)*(n-3)/(1-r*r))

1330    format(A,E9.3)
1331    format(A,I4)
1332    format(A,F5.2)
1333    format(A,F7.2,A,I4,A)
1334    format(A,E9.3,A,F6.2,A,I4,A)
1336    write(*,*) ' '
        write(*,*) '      name of output file (ENTER for none) for resid
     cuals (y-fit , y-res)'
        read(*,'(A)') unaam
        if (unaam.eq.inaam) then 
          write(*,*) ' '
          write(*,*) 'input file is not allowed to be output file!'
          goto 1336
        end if
        if (unaam.eq.' ') then
          goto 1339
        end if
        open (unit=13,file=unaam)
1337    format(2(E14.4))
        do 1338,i=1,n,1
          yfit = b0+b1*x(i)+b2*z(i)
          yres = y(i)-b0-b1*x(i)-b2*z(i)
          write (13,1337) yfit,yres
1338    continue
        close(unit=13)
1339    write(*,*) ' '
        write(*,*) '---------------------------------------------------'
        write(*,*) 'multiple regression model:  y = b0 + b1*x1 + b2*x2'
        write(*,*) ' '
        write(*,1330) ' b0   ',b0  
        write(*,1334) ' b1   ',b1,'     t ',t1,' with ',n-3,' d.f.'
        write(*,1334) ' b2   ',b2,'     t ',t2,' with ',n-3,' d.f.'
        write(*,*) ' '
        write(*,1331) ' number of data points ',n
        write(*,*) ' '
        write(*,1332) ' multiple correlation coefficient ',r 
        write(*,1332) ' squared R                        ',r*r
        write(*,1332) ' adjusted squared R               ',arr
        write(*,*) ' '
        write(*,1330) ' standard deviation of residuals   ',sqrt(sse/(n-
     c3))
        write(*,*) ' '
        write(*,1333) ' F     ',f,' with   2 and ',n-3,' degrees of free
     cdom'
        write(*,*) '---------------------------------------------------'
        goto 1990

c       subgedeelte voor drie onafhankelijke variabelen

1340    open(unit=13,file=inaam)
        do 1342,i=1,n,1
          read(unit=13,fmt=*) a,b,c,d
          x(i) = a
          y(i) = b
          z(i) = c
          v(i) = d
1342    continue
        close(unit=13)

c       uit Fortran 77 van GJ Borse p 506-7, aangepast voor multipele 
c       lineaire regressie met drie onafhankelijke variabelen:
        sx = 0
        sz = 0
        sv = 0
        sxx = 0
        szz = 0
        svv = 0
        sxz = 0
        sxv = 0
        szv = 0
        sy = 0
        sxy = 0
        szy = 0
        svy = 0
        do 1350,i=1,n,1
          sx = sx+x(i)
          sz = sz+z(i)
          sv = sv+v(i)
          sxx = sxx+x(i)*x(i)
          szz = szz+z(i)*z(i)
          svv = svv+v(i)*v(i)
          sxz = sxz+x(i)*z(i)
          sxv = sxv+x(i)*v(i)
          szv = szv+z(i)*v(i)
          sy = sy+y(i)
          sxy = sxy+x(i)*y(i)
          szy = szy+z(i)*y(i)
          svy = svy+v(i)*y(i)
1350    continue
        an = n
        call vier(an,sx,sz,sv,sx,sxx,sxz,sxv,sz,sxz,szz,szv,
     csv,sxv,szv,svv,sy,sxy,szy,svy,b0,b1,b2,b3)
c       uit essentials of biostatistics
        ygem = 0
        do 1352,i=1,n,1
          ygem = ygem+y(i)/n
1352    continue
        sse = 0
        ssr = 0
        do 1354,i=1,n,1
          ymod = b0+b1*x(i)+b2*z(i)+b3*v(i)
          ssr = ssr+((ymod-ygem)*(ymod-ygem))
          sse = sse+((y(i)-ymod)*(y(i)-ymod))
1354    continue
        f = (ssr/3)/(sse/(n-4))
        sst = ssr+sse
        r = sqrt(ssr/sst)
c       berekening "adjusted R-kwadraat" (Howell p 497)
        arr = 1-(n-1)*(1-ssr/sst)/(n-4)

c       berekening van t voor b1, b2 en b3
c       eerst X'X berekenen (X is design matrix; X' is transpose van X)
        cmlr(1,1) = 0
        cmlr(1,2) = 0
        cmlr(1,3) = 0
        cmlr(1,4) = 0
        cmlr(2,1) = 0
        cmlr(2,2) = 0
        cmlr(2,3) = 0
        cmlr(2,4) = 0
        cmlr(3,1) = 0
        cmlr(3,2) = 0
        cmlr(3,3) = 0
        cmlr(3,4) = 0
        cmlr(4,1) = 0
        cmlr(4,2) = 0
        cmlr(4,3) = 0
        cmlr(4,4) = 0
        do 1355,i=1,n,1
          cmlr(1,1) = cmlr(1,1)+1
          cmlr(1,2) = cmlr(1,2)+x(i)
          cmlr(1,3) = cmlr(1,3)+z(i)
          cmlr(1,4) = cmlr(1,4)+v(i)
          cmlr(2,1) = cmlr(2,1)+x(i)
          cmlr(2,2) = cmlr(2,2)+x(i)*x(i)
          cmlr(2,3) = cmlr(2,3)+x(i)*z(i)
          cmlr(2,4) = cmlr(2,4)+x(i)*v(i)
          cmlr(3,1) = cmlr(3,1)+z(i)
          cmlr(3,2) = cmlr(3,2)+z(i)*x(i)
          cmlr(3,3) = cmlr(3,3)+z(i)*z(i)
          cmlr(3,4) = cmlr(3,4)+z(i)*v(i)
          cmlr(4,1) = cmlr(4,1)+v(i)
          cmlr(4,2) = cmlr(4,2)+v(i)*x(i)
          cmlr(4,3) = cmlr(4,3)+v(i)*z(i)
          cmlr(4,4) = cmlr(4,4)+v(i)*v(i)
1355    continue
c       dan X'X inverteren
        call minv(cmlr,cinv,4,4,dtrmnt)
c       dan diagonaal elementen keer sse/(n-4) en wortel trekken
        seb1 = sqrt(sse*cinv(2,2)/(n-4))
        seb2 = sqrt(sse*cinv(3,3)/(n-4))
        seb3 = sqrt(sse*cinv(4,4)/(n-4))
c       t is coefficient gedeeld door bijbehorende se
        t1 = b1/seb1
        t2 = b2/seb2
        t3 = b3/seb3

1360    format(A,E9.3)
1361    format(A,I4)
1362    format(A,F5.2)
1363    format(A,F7.2,A,I4,A)
1366    write(*,*) ' '
        write(*,*) '      name of output file (ENTER for none) for resid
     cuals (y-fit , y-res)'
        read(*,'(A)') unaam
        if (unaam.eq.inaam) then 
          write(*,*) ' '
          write(*,*) 'input file is not allowed to be output file!'
          goto 1366
        end if
        if (unaam.eq.' ') then
          goto 1369
        end if
        open (unit=13,file=unaam)
1367    format(2(E14.4))
        do 1368,i=1,n,1
          yfit = b0+b1*x(i)+b2*z(i)+b3*v(i)
          yres = y(i)-b0-b1*x(i)-b2*z(i)-b3*v(i)
          write (13,1367) yfit,yres
1368    continue
        close(unit=13)
1369    write(*,*) ' '
        write(*,*) '---------------------------------------------------'
        write(*,*) 'regression model:   y = b0 + b1*x1 + b2*x2 + b3*x3'
        write(*,*) ' '
        write(*,1360) ' b0   ',b0  
        write(*,1334) ' b1   ',b1,'     t ',t1,' with ',n-4,' d.f.'
        write(*,1334) ' b2   ',b2,'     t ',t2,' with ',n-4,' d.f.'
        write(*,1334) ' b3   ',b3,'     t ',t3,' with ',n-4,' d.f.'
        write(*,*) ' '
        write(*,1361) ' number of data points ',n
        write(*,*) ' '
        write(*,1362) ' multiple correlation coefficient ',r 
        write(*,1362) ' squared R                        ',r*r
        write(*,1362) ' adjusted squared R               ',arr
        write(*,*) ' '
        write(*,1360) ' standard deviation of residuals   ',sqrt(sse/(n-
     c4))
        write(*,*) ' '
        write(*,1363) ' F     ',f,' with   3 and ',n-4,' degrees of free
     cdom'
        write(*,*) '---------------------------------------------------'
        goto 1990

c       subgedeelte voor vier onafhankelijke variabelen

1370    open(unit=13,file=inaam)
        do 1372,i=1,n,1
          read(unit=13,fmt=*) a,b,c,d,e
          x(i) = a
          y(i) = b
          z(i) = c
          v(i) = d
          w(i) = e
1372    continue
        close(unit=13)

c       uit Fortran 77 van GJ Borse p 506-7, aangepast voor multipele 
c       lineaire regressie met vier onafhankelijke variabelen:
        sx = 0
        sz = 0
        sv = 0
        sw = 0
        sxx = 0
        szz = 0
        svv = 0
        sww = 0
        sxz = 0
        sxv = 0
        sxw = 0
        szv = 0
        szw = 0
        svw = 0
        sy = 0
        sxy = 0
        szy = 0
        svy = 0
        swy = 0
        do 1380,i=1,n,1
          sx = sx+x(i)
          sz = sz+z(i)
          sv = sv+v(i)
          sw = sw+w(i)
          sxx = sxx+x(i)*x(i)
          szz = szz+z(i)*z(i)
          svv = svv+v(i)*v(i)
          sww = sww+w(i)*w(i)
          sxz = sxz+x(i)*z(i)
          sxv = sxv+x(i)*v(i)
          sxw = sxw+x(i)*w(i)
          szv = szv+z(i)*v(i)
          szw = szw+z(i)*w(i)
          svw = svw+v(i)*w(i)
          sy = sy+y(i)
          sxy = sxy+x(i)*y(i)
          szy = szy+z(i)*y(i)
          svy = svy+v(i)*y(i)
          swy = swy+w(i)*y(i)
1380    continue
        an = n
        call vijf(an,sx,sz,sv,sw,sx,sxx,sxz,sxv,sxw,sz,sxz,szz,szv,szw,s
     cv,sxv,szv,svv,svw,sw,sxw,szw,svw,sww,sy,sxy,szy,svy,swy,b0,b1,b2,b
     c3,b4)
c       uit essentials of biostatistics
        ygem = 0
        do 1382,i=1,n,1
          ygem = ygem+y(i)/n
1382    continue
        sse = 0
        ssr = 0
        do 1384,i=1,n,1
          ymod = b0+b1*x(i)+b2*z(i)+b3*v(i)+b4*w(i)
          ssr = ssr+((ymod-ygem)*(ymod-ygem))
          sse = sse+((y(i)-ymod)*(y(i)-ymod))
1384    continue
        f = (ssr/4)/(sse/(n-5))
        sst = ssr+sse
        r = sqrt(ssr/sst)
c       berekening "adjusted R-kwadraat" (Howell p 497)
        arr = 1-(n-1)*(1-ssr/sst)/(n-5)

c       berekening van t voor b1, b2, b3 en b4
c       eerst X'X berekenen
        cmlrw(1,1) = 0
        cmlrw(1,2) = 0
        cmlrw(1,3) = 0
        cmlrw(1,4) = 0
        cmlrw(1,5) = 0
        cmlrw(2,1) = 0
        cmlrw(2,2) = 0
        cmlrw(2,3) = 0
        cmlrw(2,4) = 0
        cmlrw(2,5) = 0
        cmlrw(3,1) = 0
        cmlrw(3,2) = 0
        cmlrw(3,3) = 0
        cmlrw(3,4) = 0
        cmlrw(3,5) = 0
        cmlrw(4,1) = 0
        cmlrw(4,2) = 0
        cmlrw(4,3) = 0
        cmlrw(4,4) = 0
        cmlrw(4,5) = 0
        cmlrw(5,1) = 0
        cmlrw(5,2) = 0
        cmlrw(5,3) = 0
        cmlrw(5,4) = 0
        cmlrw(5,5) = 0
        do 1385,i=1,n,1
          cmlrw(1,1) = cmlrw(1,1)+1
          cmlrw(1,2) = cmlrw(1,2)+x(i)
          cmlrw(1,3) = cmlrw(1,3)+z(i)
          cmlrw(1,4) = cmlrw(1,4)+v(i)
          cmlrw(1,5) = cmlrw(1,5)+w(i)
          cmlrw(2,1) = cmlrw(2,1)+x(i)
          cmlrw(2,2) = cmlrw(2,2)+x(i)*x(i)
          cmlrw(2,3) = cmlrw(2,3)+x(i)*z(i)
          cmlrw(2,4) = cmlrw(2,4)+x(i)*v(i)
          cmlrw(2,5) = cmlrw(2,5)+x(i)*w(i)
          cmlrw(3,1) = cmlrw(3,1)+z(i)
          cmlrw(3,2) = cmlrw(3,2)+z(i)*x(i)
          cmlrw(3,3) = cmlrw(3,3)+z(i)*z(i)
          cmlrw(3,4) = cmlrw(3,4)+z(i)*v(i)
          cmlrw(3,5) = cmlrw(3,5)+z(i)*w(i)
          cmlrw(4,1) = cmlrw(4,1)+v(i)
          cmlrw(4,2) = cmlrw(4,2)+v(i)*x(i)
          cmlrw(4,3) = cmlrw(4,3)+v(i)*z(i)
          cmlrw(4,4) = cmlrw(4,4)+v(i)*v(i)
          cmlrw(4,5) = cmlrw(4,5)+v(i)*w(i)
          cmlrw(5,1) = cmlrw(5,1)+w(i)
          cmlrw(5,2) = cmlrw(5,2)+w(i)*x(i)
          cmlrw(5,3) = cmlrw(5,3)+w(i)*z(i)
          cmlrw(5,4) = cmlrw(5,4)+w(i)*v(i)
          cmlrw(5,5) = cmlrw(5,5)+w(i)*w(i)
1385    continue
c       dan X'X inverteren
        call minv(cmlrw,cinvw,5,5,dtrmnt)
c       dan diagonaal elementen keer sse/(n-4) en wortel trekken
        seb1 = sqrt(sse*cinvw(2,2)/(n-5))
        seb2 = sqrt(sse*cinvw(3,3)/(n-5))
        seb3 = sqrt(sse*cinvw(4,4)/(n-5))
        seb4 = sqrt(sse*cinvw(5,5)/(n-5))
c       t is coefficient gedeeld door bijbehorende se
        t1 = b1/seb1
        t2 = b2/seb2
        t3 = b3/seb3
        t4 = b4/seb4

1390    format(A,E9.3)
1391    format(A,I4)
1392    format(A,F5.2)
1393    format(A,F7.2,A,I4,A)
1396    write(*,*) ' '
        write(*,*) '      name of output file (ENTER for none) for resid
     cuals (y-fit , y-res)'
        read(*,'(A)') unaam
        if (unaam.eq.inaam) then 
          write(*,*) ' '
          write(*,*) 'input file is not allowed to be output file!'
          goto 1396
        end if
        if (unaam.eq.' ') then
          goto 1399
        end if
        open (unit=13,file=unaam)
1397    format(2(E14.4))
        do 1398,i=1,n,1
          yfit = b0+b1*x(i)+b2*z(i)+b3*v(i)+b4*w(i)
          yres = y(i)-b0-b1*x(i)-b2*z(i)-b3*v(i)-b4*w(i)
          write (13,1397) yfit,yres
1398    continue
        close(unit=13)
1399    write(*,*) ' '
        write(*,*) '---------------------------------------------------'
        write(*,*) 'model:      y = b0 + b1*x1 + b2*x2 + b3*x3 + b4*x4'
        write(*,*) ' '
        write(*,1390) ' b0   ',b0  
        write(*,1334) ' b1   ',b1,'     t ',t1,' with ',n-5,' d.f.'
        write(*,1334) ' b2   ',b2,'     t ',t2,' with ',n-5,' d.f.'
        write(*,1334) ' b3   ',b3,'     t ',t3,' with ',n-5,' d.f.'
        write(*,1334) ' b4   ',b4,'     t ',t4,' with ',n-5,' d.f.'
        write(*,*) ' '
        write(*,1391) ' number of data points ',n
        write(*,*) ' '
        write(*,1392) ' multiple correlation coefficient ',r 
        write(*,1392) ' squared R                        ',r*r
        write(*,1392) ' adjusted squared R               ',arr
        write(*,*) ' '
        write(*,1390) ' standard deviation of residuals   ',sqrt(sse/(n-
     c5))
        write(*,*) ' '
        write(*,1393) ' F     ',f,' with   4 and ',n-5,' degrees of free
     cdom'
        write(*,*) '---------------------------------------------------'
        goto 1990


c       info en exit gedeelte

1990    write(*,*) ' '
        write(*,*) '      back to menu (1) or exit (2)'
        read(*,'(A)') zxcv
        if (zxcv.eq.'1') then
          goto 10
        end if
        if ((zxcv.eq.'2').or.(zxcv.eq.'e')) then
          goto 2000
        else
          write(*,*) ' '
          write(*,*) 'input not correct'
          goto 1990
        end if

1993    format(A,I5,A)
1995    write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) '---------------------------------------------------'
        write(*,*) 'NJMREG  1.0                (c) 2019 Nomdo Jansonius'
        write(*,*) ' '
        write(*,*) ' Program for performing multiple linear regression '
        write(*,*) ' '
        write(*,*) '               Supplement to: NJSTAT               '
        write(*,*) '---------------------------------------------------'
        write(*,1993) ' file size is limited to five columns and ',nrij, 
     c' rows'
        write(*,*) ' '    
        write(*,*) 'the dependent variable must always be in the second'
        write(*,*) 'column; the independent variables (2, 3, or 4) must'
        write(*,*) 'be in the first and third column, and optionally in'
        write(*,*) 'the fourth and fifth column'
        write(*,*) ' '
        write(*,*) 'if there is only 1 independent variable, use NJSTAT'
        write(*,*) '---------------------------------------------------'
        write(*,*) ' '
        write(*,*) '                        press ENTER to continue ...'
        read(*,'(A)') zxcv
        write(*,*) ' '
        goto 10
   
2000    write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) 'NJMREG collapsed to DOS'
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '
        write(*,*) ' '

        end
                                                                       


        SUBROUTINE DRIE(a11,a12,a13,a21,a22,a23,a31,a32,a33,
     cb1,b2,b3,x1,x2,x3)

c       drie vergelijkingen met drie onbekenden oplossen m.b.v. Cramer's 
c       rule; zie Borse p 441

        d = a11*a22*a33+a12*a23*a31+a13*a32*a21
     c-a11*a23*a32-a21*a12*a33-a31*a22*a13

        tx1 = b1*(a22*a33-a23*a32)-b2*(a12*a33-a13*a32)
     c+b3*(a12*a23-a13*a22)

        tx2 = b1*(a23*a31-a21*a33)+b2*(a11*a33-a13*a31)
     c+b3*(a13*a21-a11*a23)

        tx3 = b1*(a21*a32-a22*a31)+b2*(a12*a31-a11*a32)
     c+b3*(a11*a22-a12*a21)

        x1 = tx1/d
        x2 = tx2/d
        x3 = tx3/d

        end


        SUBROUTINE VIER(a11,a12,a13,a14,a21,a22,a23,a24,a31,a32,a33,a34,
     ca41,a42,a43,a44,b1,b2,b3,b4,x1,x2,x3,x4)

c       vier vergelijkingen met vier onbekenden oplossen m.b.v. de Gauss-
c       Jordan method (matrix schoonvegen); zie Borse p 447-454

        real a(4,4),b(4)

        a(1,1) = a11
        a(1,2) = a12
        a(1,3) = a13
        a(1,4) = a14
        a(2,1) = a21
        a(2,2) = a22
        a(2,3) = a23
        a(2,4) = a24
        a(3,1) = a31
        a(3,2) = a32
        a(3,3) = a33
        a(3,4) = a34
        a(4,1) = a41
        a(4,2) = a42
        a(4,3) = a43
        a(4,4) = a44
        b(1) = b1
        b(2) = b2
        b(3) = b3
        b(4) = b4

        do 4,ipv=1,4,1
          pivot = a(ipv,ipv)
          do 1,j=1,4,1
             a(ipv,j) = a(ipv,j)/pivot
1         continue
          b(ipv) = b(ipv)/pivot
          do 3,irow=1,4,1
            if (irow.ne.ipv) then
c       de volgende regel staat fout in het boek op p 453
              fctr = a(irow,ipv)
              do 2,icol=1,4,1
                a(irow,icol) = a(irow,icol)-fctr*a(ipv,icol)
2             continue
              b(irow) = b(irow)-fctr*b(ipv)
            end if
3         continue
4       continue

        x1 = b(1)
        x2 = b(2)
        x3 = b(3)
        x4 = b(4)

        end


        SUBROUTINE VIJF(a11,a12,a13,a14,a15,a21,a22,a23,a24,a25,a31,a32,
     ca33,a34,a35,a41,a42,a43,a44,a45,a51,a52,a53,a54,a55,b1,b2,b3,b4,b5
     c,x1,x2,x3,x4,x5)

c       vijf vergelijkingen met vijf onbekenden oplossen m.b.v. de Gauss-
c       Jordan method (matrix schoonvegen); zie Borse p 447-454

        real a(5,5),b(5)

        a(1,1) = a11
        a(1,2) = a12
        a(1,3) = a13
        a(1,4) = a14
        a(1,5) = a15
        a(2,1) = a21
        a(2,2) = a22
        a(2,3) = a23
        a(2,4) = a24
        a(2,5) = a25
        a(3,1) = a31
        a(3,2) = a32
        a(3,3) = a33
        a(3,4) = a34
        a(3,5) = a35
        a(4,1) = a41
        a(4,2) = a42
        a(4,3) = a43
        a(4,4) = a44
        a(4,5) = a45
        a(5,1) = a51
        a(5,2) = a52
        a(5,3) = a53
        a(5,4) = a54
        a(5,5) = a55
        b(1) = b1
        b(2) = b2
        b(3) = b3
        b(4) = b4
        b(5) = b5

        do 4,ipv=1,5,1
          pivot = a(ipv,ipv)
          do 1,j=1,5,1
             a(ipv,j) = a(ipv,j)/pivot
1         continue
          b(ipv) = b(ipv)/pivot
          do 3,irow=1,5,1
            if (irow.ne.ipv) then
c       de volgende regel staat fout in het boek op p 453
              fctr = a(irow,ipv)
              do 2,icol=1,5,1
                a(irow,icol) = a(irow,icol)-fctr*a(ipv,icol)
2             continue
              b(irow) = b(irow)-fctr*b(ipv)
            end if
3         continue
4       continue

        x1 = b(1)
        x2 = b(2)
        x3 = b(3)
        x4 = b(4)
        x5 = b(5)

        end


        SUBROUTINE MINV(A,AINV,ND,N,DET)

c       MINV berekent de inverse van een n x n matrix

c       Uit: Fortran 77 and Numerical Methods for Engineers
c       van GJ Borse, p 468-470

        integer ND,N,IPASS
        real A(ND,ND),AINV(ND,ND),DET,FCTR

        DET = 1.0
        DO 1 I = 1,N
        DO 1 J = 1,N
          IF(I.EQ.J) THEN
            AINV(I,J) = 1.0
          ELSE
            AINV(I,J) = 0.0
          END IF
1       CONTINUE

        DO 7 IPASS = 1,N

          IMX = IPASS
          DO 2 IROW = IPASS,N
            IF(ABS(A(IROW,IPASS)).GT.ABS(A(IMX,IPASS))) THEN
              IMX = IROW
            END IF
2         CONTINUE

          IF(IMX.NE.IPASS) THEN
            DO 3 ICOL = 1,N
              TEMP = AINV(IPASS,ICOL)
              AINV(IPASS,ICOL) = AINV(IMX,ICOL)
              AINV(IMX,ICOL) = TEMP
              IF(ICOL.GE.IPASS) THEN
                TEMP = A(IPASS,ICOL)
                A(IPASS,ICOL) = A(IMX,ICOL)
                A(IMX,ICOL) = TEMP
              END IF
3           CONTINUE
          END IF

          PIVOT = A(IPASS,IPASS)
          DET = DET*PIVOT

          IF(DET.EQ.0.0) THEN
            WRITE(*,*) 'UNFORTUNATELY: ZERO DETERMINANT!'
          END IF

          DO 4 ICOL = 1,N
            AINV(IPASS,ICOL) = AINV(IPASS,ICOL)/PIVOT
            IF(ICOL.GE.IPASS) THEN
              A(IPASS,ICOL) = A(IPASS,ICOL)/PIVOT
            END IF
4         CONTINUE

          DO 6 IROW = 1,N
            IF(IROW.NE.IPASS) THEN
              FCTR = A(IROW,IPASS)
              DO 5 ICOL = 1,N
                AINV(IROW,ICOL) = 
     c                  AINV(IROW,ICOL)-FCTR*AINV(IPASS,ICOL)
                A(IROW,ICOL)=A(IROW,ICOL)-FCTR*A(IPASS,ICOL)
5             CONTINUE
            END IF
6         CONTINUE
7       CONTINUE

        RETURN

        END
